﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="RelatedLabDetails.ascx.cs" Inherits="controls_RelatedLabDetails" %>
<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:GridView ID = "GridViewRelatedLabDetails" runat = "server" 
    DataSourceID = "ObjectDataSourceLabDetails" 
    AutoGenerateColumns = "false"
    AllowPaging="False" 
    DataKeyNames = "RELATED_LAB_TEST_ID"  
    AllowSorting = "true"
    SkinID = "Unsortable" Width="100%"
    UseAccessibleHeader = "true">
    <EmptyDataTemplate>
        No related lab tests found for this patient 
    </EmptyDataTemplate>                     
    <Columns>
        <asp:TemplateField AccessibleHeaderText = "Result Date" HeaderText = "Result Date" >
            <ItemTemplate>
                 <asp:Label ID = "LabelResultDate" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LAB_COMPLETE_DATE", "{0:M/d/yyyy H:mm}")), false) %>' SkinID = "DataLabel" /> 
                            
            </ItemTemplate>
         </asp:TemplateField>
         
         <asp:TemplateField AccessibleHeaderText = "Date Specimen Collected" HeaderText = "Date Specimen Collected">    
            <ItemTemplate>
                <asp:Label ID = "LabelSpecimenDate" runat = "server" 
                Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LAB_SPECIMEN_DATE", "{0:M/d/yyyy H:mm}")), false) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Result" HeaderText = "Result">    
            <ItemTemplate>
                <asp:Label ID = "LabelResult" runat = "server" 
                Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LAB_RESULT_VALUE")), false) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Result Units" HeaderText = "Result Units">    
            <ItemTemplate>
                <asp:Label ID = "LabelResultUnits" runat = "server" 
                Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LAB_RESULT_UNIT")), false) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Ref Low" HeaderText = "Ref Low">    
            <ItemTemplate>
                <asp:Label ID = "LabelRefLow" runat = "server" 
                Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("REF_LOW")), false) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Ref High" HeaderText = "Ref High">    
            <ItemTemplate>
                <asp:Label ID = "LabelRefHigh" runat = "server" 
                Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("REF_HIGH")), false) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Abnormal Indicator" HeaderText = "Abnormal Indicator">    
            <ItemTemplate>
                <asp:Label ID = "LabelAbnormal" runat = "server" 
                Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("ABNORMAL")), false) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Request Site Number" HeaderText = "Request Site Number">    
            <ItemTemplate>
                <asp:Label ID = "LabelRequestSiteNumber" runat = "server" 
                Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION_REQUESTING.STATIONNUMBER")), false) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    
            
         <asp:TemplateField AccessibleHeaderText = "Result Site Number" HeaderText = "Result Site Number">    
            <ItemTemplate>
                <asp:Label ID = "LabelResultSiteNumber" runat = "server" 
                Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("STD_INSTITUTION_RESULTING.STATIONNUMBER")), false) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    

         <asp:TemplateField AccessibleHeaderText = "LOINC" HeaderText = "LOINC">    
            <ItemTemplate>
                <asp:Label ID = "LabelLOINC" runat = "server" 
                Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("LONINC_CODE")), false) %>' SkinID = "DataLabel" />
            </ItemTemplate> 
         </asp:TemplateField>    

    </Columns> 
</asp:GridView> 
<asp:HiddenField runat="server" ID="HiddenFieldPatientID" />
<asp:HiddenField runat="server" ID="HiddenFieldLabName" />
<asp:HiddenField runat="server" ID="HiddenFieldSpecimenType" />

<asp:ObjectDataSource ID = "ObjectDataSourceLabDetails" runat = "server" 
SelectMethod="SelectRelatedLabTestsDetail"  
    EnablePaging="false" 
    TypeName="VeteransAffairs.Registries.BusinessManager.EFR.RelatedLabTestManager">
    <SelectParameters>            
       <asp:ControlParameter ControlID="HiddenFieldPatientID"
           ConvertEmptyStringToNull = "true"  Direction="Input"  DefaultValue="0"
           Name="patientId" Type="Int32"/>
       <asp:ControlParameter ControlID="HiddenFieldLabName"
           ConvertEmptyStringToNull = "true"  Direction="Input"  DefaultValue="0"
           Name="labName" Type="String"/>
       <asp:ControlParameter ControlID="HiddenFieldSpecimenType"
           ConvertEmptyStringToNull = "true"  Direction="Input"  DefaultValue="0"
           Name="specimenType" Type="String"/>

    </SelectParameters>
 </asp:ObjectDataSource>     
